% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_modules.R
\name{get_modules}
\alias{get_modules}
\title{Get the SIA Modules Manifest for the currently developed package}
\usage{
get_modules(proj = curr_proj())
}
\arguments{
\item{proj}{\emph{character}, a path to the project. Defaults to \link[=curr_proj]{current project}.}
}
\value{
A SIA Modules Manifest of class \code{sm_manifest}. Inherits from a
\code{list}.
}
\description{
Returns a list with all modules for the current package as described in its
SIA Modules Manifest, which resides at \verb{/inst/sia/modules.yml} and is
generated with \code{\link[=add_module]{add_module()}} calls. Can be formatted as a \code{tibble} using the
respective \link[=print.sm_manifest]{print method}.
}
\examples{
\dontrun{
get_modules()
}

}
\seealso{
Other module management functions:
\code{\link{add_module}()},
\code{\link{preview_module}()},
\code{\link{remove_module}()}
}
\concept{module_management}
