% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sgp}
\alias{plot.sgp}
\title{Plots the coefficient path of an SGP object}
\usage{
\method{plot}{sgp}(x, alpha = 1, legend.pos, label = FALSE, log.l = FALSE, norm = FALSE, ...)
}
\arguments{
\item{x}{A object that was generated with sgp.}

\item{alpha}{Tuning parameter for the alpha-blending.}

\item{legend.pos}{Coordinates or keyword for positioning the legend.}

\item{label}{A Boolean value that specifies whether the plot should be annotated.}

\item{log.l}{A Boolean value that specifies whether the horizontal axis should be on the log scale.}

\item{norm}{A Boolean value that specifies whether the norm of each group should be plotted.}

\item{\dots}{Other parameters of underlying basic functions.}
}
\value{
A plot object with the coefficient path of an SGP.
}
\description{
Produces a coefficient profile plot of the coefficient paths for a fitted SGP object
}
\examples{
n <- 100
p <- 12
nr <- 4
g <- paste0("Group ",ceiling(1:p / nr))
X <- matrix(rnorm(n * p), n, p)
b <- c(-3:3)
y_lin <- X[, 1:length(b)] \%*\% b + 5 * rnorm(n)
y_log <- rbinom(n, 1, exp(y_lin) / (1 + exp(y_lin)))

lin_fit <- sgp(X, y_lin, g, type = "linear")
plot(lin_fit, legend.pos = "topright", label = TRUE)
plot(lin_fit,  label = TRUE, norm = TRUE)

log_fit <- sgp(X, y_log, g, type = "logit")
plot(log_fit, legend.pos = "topright", label = TRUE)
plot(log_fit, label = TRUE, norm = TRUE)

}
