% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test13.R
\name{Test13}
\alias{Test13}
\title{Use Brute Search with Cut Method to Try to Switch Sign of Parameter}
\usage{
Test13(
  df,
  model,
  var_one,
  var_two,
  PAR,
  threshold,
  fit,
  estimates,
  conc,
  int,
  par_value,
  max_final,
  N,
  signFactor,
  ...
)
}
\arguments{
\item{df}{A data frame containing the dataset.}

\item{model}{A specified SEM model.}

\item{var_one}{The first variable of interest.}

\item{var_two}{The second variable of interest.}

\item{PAR}{The path of interest.}

\item{threshold}{The threshold for the percentage of data dropped.}

\item{fit}{The SEM object.}

\item{estimates}{The estimates from the SEM model.}

\item{conc}{A data frame containing the parameter of interest.}

\item{int}{The value of the path of interest.}

\item{par_value}{The original value of the parameter of interest.}

\item{max_final}{The maximum number of influential data points to consider.}

\item{N}{The total number of data points.}

\item{signFactor}{A factor indicating the direction of parameter change (positive or negative).}

\item{...}{Other arguments.}
}
\value{
A list of class \code{TestResult13} containing:
\item{bruteSearchDrops}{The indices of the most influential data points selected by the brute search method.}
\item{initialValue}{The original value of the parameter.}
\item{finalValue}{The final value of the parameter after applying the brute search method.}
\item{methodname}{The name of the method used.}
\item{testindex}{The index of the test performed.}
\item{PAR}{The path of interest that was evaluated.}
\item{threshold}{The threshold used for the percentage of dropped points.}
\item{N}{The total number of data points.}
\item{max_final}{The maximum number of points allowed to be dropped.}
\item{par_value}{The original value of the parameter.}
}
\description{
This function uses a brute-force search method with pruning (cutting) to iteratively search for combinations of data points that switch the sign of a specific path in a Structural Equation Modeling (SEM) model.
}
\examples{
\donttest{
library(lavaan)
library(dplyr)
library(semfindr)
library(R.utils)


# Import data
df <- PoliticalDemocracy

# Build Model
model <- '
  # measurement model
  ind60 =~ x1 + x2 + x3
  dem60 =~ y1 + y2 + y3 + y4
  dem65 =~ y5 + y6 + y7 + y8
  # regressions
  dem60 ~ ind60
  dem65 ~ ind60 + dem60
  # residual correlations
  y1 ~~ y5
  y2 ~~ y4 + y6
  y3 ~~ y7
  y4 ~~ y8
  y6 ~~ y8
'

var_one <- 'dem65' # first term
var_two <- 'ind60' # second term
PAR <- c("dem65~ind60") # full relation
threshold <- 10

# Fit SEM model
fit <- lavaan::sem(model, data = df)
summary(fit)

# Get Estimates of Parameters from SEM
estimates <- parameterEstimates(fit)

# Determine the value of the parameter of interest
conc <- data.frame(lhs = estimates$lhs, rhs = estimates$rhs, est = estimates$est)
int <- conc \%>\% filter(lhs == var_one & rhs == var_two)
par_value <- int$est # this is the value of the parameter of interest

# Compute the max number of points to be dropped
max_final <- ceiling(threshold * nrow(df) / 100) # perform rounding if necessary
N <- nrow(df) # store the number of observations in df for convenience

# Determine whether the parameter is negative or positive in order
# to assess which direction to perturb it
signFactor <- ifelse(par_value >= 0L, TRUE, FALSE)

Test13_result = Test13(df, model, var_one, var_two, PAR, threshold, fit, estimates,
conc, int, par_value, max_final, N, signFactor)
summary(Test13_result)
}
}
