% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{genTheta}
\alias{genTheta}
\title{Dependency Matrix Theta}
\usage{
genTheta(q, param, structure = "MA")
}
\arguments{
\item{q}{model order (integer).}

\item{param}{MA parameter (numeric value between 0 and 1).}

\item{structure}{Character string, either "MA" or "AR" indicating the structure of the dependency matrix. Details below.}
}
\value{
A matrix of size (2q + 1) x (2q + 1).
}
\description{
This function generates a symmetric dependency matrix \eqn{\Theta} of a
specific type of spatial MA(q) model.
}
\details{
Symmetric spatial MA(q) model (or an approximation to a spatial AR(1) model) for 2-dim. random fields:
\deqn{Y_{ij} = \sum_{k = -q}^q \sum_{l = -q}^q \theta_{kl} \varepsilon_{kl}.}
\eqn{(\theta_{kl}) = \Theta}. \cr \cr
For "MA": \deqn{\theta_{kl} = \code{param}^{|k - q - 1| + |l - q - 1|}.}
For "AR": \deqn{\theta_{kl} = \tilde{\theta}_{kl} / \sqrt{\sum_{|k| \leq q} \sum_{|l| \leq q} \tilde{\theta}^2_{kl}} 
         \quad \text{ with } \quad \tilde{\theta}_{kl} = \code{param}^{\sqrt{k^2 + l^2}}.}
}
\examples{
genTheta(1, 0.2, "MA")

genTheta(40, 0.2, "AR")

}
