% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges.R
\name{plot.edges}
\alias{plot.edges}
\alias{image.edges}
\title{Plot}
\usage{
\method{plot}{edges}(x, Blocks, sorted = TRUE, xlab = "Node", ylab = "Node", ...)

\method{image}{edges}(x, Blocks, sorted = TRUE, xlab = "Node", ylab = "Node", ...)
}
\arguments{
\item{x}{an \code{\link{edges}} object}

\item{Blocks}{a blocks object or \code{\link{sbm}} object}

\item{sorted}{sort by block membership in \code{\link{sbm}} before plotting?}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{...}{parameters for \code{image}}
}
\value{
\code{ggplot2} plot of edges in a raster
}
\description{
plots an \code{\link{edges}} objects
}
\examples{
## make an sbm model, sample data then plot and print:
model <- sbmmod(dma(2,5), param_beta(1,1,1,1), edges_bern())
s <- model$r(100)
e <- redges(s, model$edge)
plot(e)
plot(e, s)
print(e)
}
