% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidateset.R
\name{modelset}
\alias{modelset}
\title{Construct model pool using the two-step algorithm}
\usage{
modelset(data, lambda, P)
}
\arguments{
\item{data}{A \code{n} by \code{p} data frame of observations}

\item{lambda}{Tuning parameter vector}

\item{P}{Prior adjacency matrix}
}
\value{
A list including all the candidate models in the model pool. 
  Each model is represented by a \code{p} by \code{p} adjacency matrix
}
\description{
For a given prior graph, the two-step algorithm, including edge enrichment and pruning, 
  is used to construct the model pool
}
\examples{
\donttest{
  set.seed(1)
  d=simulate(n=100, p=100, m1 = 100, m2 = 30)
  data=d$data
  P=d$priornetwork
  lambda=exp(seq(-5,5,length=100))
  candidates=modelset(data=data,lambda=lambda, P=P)
}
}
\author{
Jie Zhou
}
