% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.ernet.R
\name{coef.ernet}
\alias{coef.ernet}
\alias{coef.alspath}
\title{Get coefficients from an ernet object}
\usage{
\method{coef}{ernet}(object, s = NULL, type = c("coefficients", "nonzero"), ...)
}
\arguments{
\item{object}{fitted \code{\link{ernet}} model object.}

\item{s}{value(s) of the penalty parameter \code{lambda} at which predictions
are to be made. Default is the entire sequence used to create the model.}

\item{type}{type \code{"coefficients"} computes coefficients at the requested
values for \code{s}. Type \code{"nonzero"} returns a list of the indices of
nonzero coefficients for each value of \code{s}. Default is
\code{"coefficients"}.}

\item{\dots}{not used. Other arguments to predict.}
}
\value{
The object returned depends on type.
}
\description{
Computes the coefficients or returns a list of the indices of the nonzero
coefficients at the requested values for \code{lambda} from a fitted ernet
object.
}
\details{
\code{s} is the new vector at which predictions are requested. If
  \code{s} is not in the lambda sequence used for fitting the model, the
  \code{coef} function will use linear interpolation to make predictions. The
  new values are interpolated using a fraction of coefficients from both left
  and right \code{lambda} indices.
}
\examples{

set.seed(1)
n <- 100
p <- 400
x <- matrix(rnorm(n * p), n, p)
y <- rnorm(n)
tau <- 0.90
pf <- abs(rnorm(p))
pf2 <- abs(rnorm(p))
lambda2 <- 1
m1 <- ernet(y = y, x = x, tau = tau, eps = 1e-8, pf = pf,
            pf2 = pf2, standardize = FALSE, intercept = FALSE,
            lambda2 = lambda2)
as.vector(coef(m1, s = m1$lambda[5]))

}
\seealso{
\code{\link{ernet}}, \code{\link{predict.ernet}},
  \code{\link{print.ernet}}, \code{\link{plot.ernet}}
}
\author{
Yuwen Gu and Hui Zou\cr

Maintainer: Yuwen Gu <yuwen.gu@uconn.edu>
}
\keyword{models}
\keyword{regression}
