% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify_random.R
\name{stratify_random}
\alias{stratify_random}
\title{Split data for k-fold spatially stratified cross validation}
\usage{
stratify_random(occurrence_sf, nfolds = NULL)
}
\arguments{
\item{occurrence_sf}{a sf object containing occurrence records}

\item{nfolds}{number of desired output folds.}
}
\value{
Returns a sf dataframe containing fold designation for each point.
}
\description{
Splitting tool for cross-validation
}
\details{
See Examples.
}
\examples{
{

# load in sample data

 library(S4DM)
 library(terra)
 library(sf)

 # occurrence points
   data("sample_points")
   occurrences <- sample_points


 occurrences <- st_as_sf(x = occurrences,coords = c(1,2))


random_folds <- stratify_random(occurrence_sf = occurrences,
                               nfolds = 5)


}
}
\author{
Cory Merow \href{mailto:cory.merow@gmail.com}{cory.merow@gmail.com}
}
