% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RvegCheck.R
\name{RvegCheck}
\alias{RvegCheck}
\title{RvegCheck: Inspect, Validate, Edit and Repair an Rveg Database}
\usage{
RvegCheck(database, export = "export", checklist = "default")
}
\arguments{
\item{database}{Character. The path and name of the existing \code{Rveg} database
to inspect (e.g., \code{"path/to/my_db"}).}

\item{export}{Character. The output path and name where the modified
database will be saved. Defaults to a temporary directory.}

\item{checklist}{Character. The species checklist to validate the database against.
By default, it uses the checklist defined in the database's metadata.}
}
\value{
Currently prints diagnostic information directly to the R console.
If modifications are made, it exports the updated database files (\verb{*HEAD.csv}
and \verb{*REL.csv}) to the path specified by \code{export}.
}
\description{
A diagnostic and managing utility to verify the health and integrity of an \code{Rveg} database.
\code{RvegCheck()} reads your database, checks for missing or corrupted data,
and outputs a summary of the database's current state.
}
\details{
\emph{Note: This function is currently under active development.} #'
At present, the function serves primarily as a diagnostic and metadata-repair tool.
When run, it checks the database for a \code{project_name} and \code{project_description}.
If these are missing, it will interactively prompt the user to supply them. It also
prints vital database statistics, including the internal ID, creation date, last
modification date, and any custom species added to the checklist.

In future updates, this function will also allow users to modify core database
parameters, such as swapping the underlying species checklist or altering the
header schema.
}
\examples{
if (interactive()) {
  # Inspect the built-in example database
  RvegCheck(
    database = file.path(path.package("Rveg"), "extdata/ExampleDB", "example_1")
  )
}

}
\seealso{
\code{\link{RvegMerge}} for combining databases, \code{\link{RvegCombine}} for manipulating data within a database.
}
