% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_invalid_coordinates.R
\name{remove_invalid_coordinates}
\alias{remove_invalid_coordinates}
\title{Identify and remove invalid coordinates}
\usage{
remove_invalid_coordinates(
  occ,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  return_invalid = TRUE,
  save_invalid = FALSE,
  output_dir = NULL,
  overwrite = FALSE,
  output_format = ".gz",
  verbose = FALSE
)
}
\arguments{
\item{occ}{(data.frame or data.table) a dataset with occurrence records.}

\item{long}{(character) column name in \code{occ} with the longitude.}

\item{lat}{(character) column name in \code{occ} with the latitude.}

\item{return_invalid}{(logical) whether to return a list containing the valid
and invalid coordinates. Default is TRUE.}

\item{save_invalid}{(logical) whether to save the invalid (removed) records.
If \code{TRUE}, an \code{output_dir} must be provided. Default is \code{FALSE}.}

\item{output_dir}{(character) path to an existing directory where records with
invalid coordinates will be saved. Only used when \code{save_invalid = TRUE}.}

\item{overwrite}{(logical)  whether to overwrite existing files in
\code{output_dir}. Only used when \code{save_invalid = TRUE}. Default is \code{FALSE}.}

\item{output_format}{(character) output format for saving removed records.
Options are \code{".csv"} or \code{".gz"}. Only used when \code{save_invalid = TRUE}.
Default is \code{".gz"}.}

\item{verbose}{(logical) whether to print messages about function progress.
Default is \code{TRUE}.}
}
\value{
If \code{return_invalid = FALSE}, returns the occurrence dataset containing only
valid coordinates.
If \code{return_invalid = TRUE} (default), returns a list with two elements:
\itemize{
\item \code{valid} – the dataset with valid coordinates.
\item \code{invalid} – the dataset with invalid coordinates removed.
}
}
\description{
This function identifies and removes invalid geographic coordinates,
including non-numeric values, NA or empty values, and coordinates outside the
valid range for Earth (latitude > 90 or < -90, and longitude > 180 or < -180).
}
\examples{
# Create fake data example
occ <- data.frame("species" = "spp",
                  "decimalLongitude" = c(10, -190, 20, 50, NA),
                  "decimalLatitude" = c(20, 20, 240, 50, NA))
# Split valid and invalid coordinates
occ_valid <- remove_invalid_coordinates(occ)
}
