% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmap_here.R
\name{ggmap_here}
\alias{ggmap_here}
\title{Static Visualization of Occurrence Flags with ggplot}
\usage{
ggmap_here(
  occ,
  species = NULL,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  flags = "all",
  additional_flags = NULL,
  names_additional_flags = NULL,
  col_additional_flags = NULL,
  show_no_flagged = TRUE,
  col_points = NULL,
  size_points = 1,
  heatmap = NULL,
  low_color = "blue",
  mid_color = "yellow",
  high_color = "red",
  midpoint = 0.5,
  alpha_heatmap = 0.5,
  continent = NULL,
  continent_fill = "gray70",
  continent_linewidth = 0.3,
  continent_border = "white",
  ocean_fill = "aliceblue",
  extension = NULL,
  facet_wrap = FALSE,
  theme_plot = ggplot2::theme_minimal(),
  ...
)
}
\arguments{
\item{occ}{(data.frame or data.table) a dataset containing occurrence records
that has been processed by one or more flagging functions. See \emph{Details} for
available flag types.}

\item{species}{(character) name of the species to subset and plot. Default is
\code{NULL}, meaning that all records for all species are plotted.}

\item{long}{(character) the name of the column in \code{occ} that contains the
longitude values. Default is \code{"decimalLongitude"}.}

\item{lat}{(character) the name of the column in \code{occ} that contains the
latitude values. Default is \code{"decimalLatitude"}.}

\item{flags}{(character) the flags to be used for coloring the records. Use
\code{"all"} to display all available flags. See \emph{Details} for all options.
Default is \code{"all"}.}

\item{additional_flags}{(character) an optional named character vector with
the names of additional logical columns to be used as flags. Default is \code{NULL}.}

\item{names_additional_flags}{(character) an optional different name to the
flag provided in \code{additional_flags} to be shown in the map. Only applicable
if \code{additional_flags} is not NULL.}

\item{col_additional_flags}{(character) if \code{additional_flags} is provided,
the color of the records flagged in this column. Obligatory if
\code{additional_flags} is not NULL.}

\item{show_no_flagged}{(logical) whether to display records that did not
receive any flag.Default is TRUE.}

\item{col_points}{(character) A \strong{named vector} assigning colors to each
flag. If \code{NULL}, default colors from the internal object
\code{RuHere::flag_colors()} are used.}

\item{size_points}{(numeric) point size for plotting occurrences.
Default is 6.}

\item{heatmap}{(SpatRaster) an optional heatmap containing the estimated density
of occurrence records, typically generated by the \code{spatial_kde()} function.
Default is NULL.}

\item{low_color}{(character) color used for the lowest density values in the
heatmap. Only applicable if a heatmap is provided. Default is "blue".}

\item{mid_color}{(character) color used for the midpoint of the heatmap
gradient. Default is "yellow".}

\item{high_color}{(character) color used for the highest density values in
the heatmap. Default is "red".}

\item{midpoint}{(numeric) the central value of the heatmap gradient,
corresponding to \code{mid_color}. Default is 0.5.}

\item{alpha_heatmap}{(numeric) Alpha transparency applied to the heatmap
layer, ranging from 0 (fully transparent) to 1 (fully opaque). Default is 0.5.}

\item{continent}{(SpatVector) optional polygon layer representing continent
boundaries. If \code{NULL}, a built-in simplified world map is used (see
\emph{Details}). Default: \code{NULL}.}

\item{continent_fill}{(character) fill color for the continent polygons.
Default is "gray70".}

\item{continent_linewidth}{(numeric) line width for continent boundaries.
Default is 0.3.}

\item{continent_border}{(character) color of the continent polygon borders.
Default is "white".}

\item{ocean_fill}{(character) background color used to represent the ocean.
Default is "aliceblue".}

\item{extension}{(SpatExtent or numeric) optional map extent specified as a
\code{SpatExtent} or as a numeric vector of length 4 in the order:
\verb{xmin, xmax, ymin, ymax}. Default is \code{NULL} (computed automatically from the
extent of the occurrence data).}

\item{facet_wrap}{(logical) whether to plots each flag in a separate panel
using \code{ggplot2::facet_wrap()}. Default is \code{FALSE}.}

\item{theme_plot}{(theme) a \code{ggplot2} theme object. Default is
\code{ggplot2::theme_minimal()}.}

\item{...}{other arguments passed to \code{ggplot2::theme()}.}
}
\value{
An ggplot object displaying flagged and optionally unflagged occurrence
records.
}
\description{
This function creates a static map of occurrence records using \strong{ggplot2},
highlighting which points were flagged by data-validation functions. This
visualization helps users quickly inspect spatial patterns of flagged and
unflagged records and diagnose potential data-quality issues.

The function can also be used to plot the heatmap generated by the
\code{spatial_kde()} function.
}
\details{
This function expects an occurrence dataset that has already been processed
by one or more flagging routines from \strong{RuHere} or related packages such as
\strong{CoordinateCleaner}. Any logical column in \code{occ} can be used as a flag.

The following built-in flag names are recognized:
\emph{From RuHere}:
\code{correct_country}, \code{correct_state}, \code{cultivated}, \code{florabr}, \code{faunabr},
\code{wcvp}, \code{iucn}, \code{bien}, \code{duplicated}, \code{thin_geo}, \code{thin_env}, \code{consensus}

\emph{From CoordinateCleaner}:
\code{.val}, \code{.equ}, \code{.zer}, \code{.cap}, \code{.cen}, \code{.sea}, \code{.urb}, \code{.otl}, \code{.gbf},
\code{.inst}, \code{.aohi}

Users may also supply additional logical columns using
\code{additional_flags}, optionally providing alternative display names
(\code{names_additional_flags}) and colors (\code{col_additional_flags}).

If \code{continent} is not provided, the background map is a simplified world
polygon included with the package (a modified version of
\code{rnaturalearthdata::map_units110}). To inspect this object, run:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{terra::unwrap(getExportedValue("RuHere", "world"))
}\if{html}{\out{</div>}}

When \code{facet_wrap = TRUE}, each flag is plotted in a separate panel,
allowing direct comparison among different types of data issues.
}
\examples{
# Load example data
data("occ_flagged", package = "RuHere")
# Visualize all flags with ggplot
ggmap_here(occ = occ_flagged)
# Visualize each flag in a separate panel
ggmap_here(occ = occ_flagged, facet_wrap = TRUE)
}
