% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.tropsvm.R
\name{cv.tropsvm}
\alias{cv.tropsvm}
\title{Cross-Validation for Tropical Support Vector Machines}
\usage{
cv.tropsvm(x, y, parallel = FALSE, nfold = 10, nassignment = 10, ncores = 2)
}
\arguments{
\item{x}{a data matrix, of dimension nobs x nvars; each row is an observation vector.}

\item{y}{a response vector with one label for each row/component of x.}

\item{parallel}{a logical value indicating if parallel computing should be used. (default: FALSE)}

\item{nfold}{a numeric value of the number of data folds for cross-validation. (default: 10)}

\item{nassignment}{a numeric value indicating the size of the parameter grid of assignments. (default: 10)}

\item{ncores}{a numeric value indicating the number of threads utilized for multi-cored CPUs. (default: 2)}
}
\value{
object with S3 class \code{cv.tropsvm} containing the fitted model, including:
\item{apex}{The negative apex of the fitted optimal tropical hyperplane.}
\item{assignment}{The best \code{assignment} tuned by cross-validation.}
\item{index}{The best classification method tuned by cross-validation.}
\item{levels}{The name of each category, consistent with categories in \code{y}.}
\item{accuracy}{The validation accuracy for each fold.}
\item{nfold}{The number of folds used in cross-validation.}
}
\description{
Conduct k-fold cross validation for tropsvm and return an object \code{"cv.tropsvm"}.
}
\examples{

# data generation
library(Rfast)
set.seed(101)
e <- 20
n <- 10
N <- 10
s <- 5
x <- rbind(
  rmvnorm(n, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(n, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
y <- as.factor(c(rep(1, n), rep(2, n)))
newx <- rbind(
  rmvnorm(N, mu = c(5, -5, rep(0, e - 2)), sigma = diag(s, e)),
  rmvnorm(N, mu = c(-5, 5, rep(0, e - 2)), sigma = diag(s, e))
)
newy <- as.factor(rep(c(1, 2), each = N))

# train the tropical svm
cv_tropsvm_fit <- cv.tropsvm(x, y, parallel = FALSE)

summary(cv_tropsvm_fit)
coef(cv_tropsvm_fit)

# test with new data
pred <- predict(cv_tropsvm_fit, newx)

# check with accuracy
table(pred, newy)

# compute testing accuracy
sum(pred == newy) / length(newy)
}
\seealso{
\code{summary}, \code{predict}, \code{coef} and the \code{tropsvm} function.
}
