% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_cong.R
\name{max_cong}
\alias{max_cong}
\title{Algortihm for maximizing congruence between two phylogenies}
\usage{
max_cong(
  HS,
  treeH,
  treeS,
  n,
  N,
  method = "paco",
  symmetric = FALSE,
  ei.correct = "none",
  percentile = 0.01,
  res.fq = TRUE,
  strat = "sequential",
  cl = 1
)
}
\arguments{
\item{HS}{Host-Symbiont association matrix.}

\item{treeH}{Host phyolgeny. An object of class "phylo".}

\item{treeS}{Symbiont phylogeny. An object of class "phylo".}

\item{n}{Number of unique associations.}

\item{N}{Number of runs.}

\item{method}{Specifies the desired global-fit method (GD, PACo or ParaFit).
The default is \code{PACo}. Options are \code{"geoD"} (Geodesic
Distances), \code{"paco"} (PACo) or \code{"paraF"} (ParaFit).}

\item{symmetric}{Specifies the type of Procrustes superimposition. Default
is \code{FALSE}, indicates that the superposition is applied
asymmetrically (S depends on H). If \code{TRUE}, PACo is applied
symmetrically (dependency between S and H is reciprocal).}

\item{ei.correct}{Specifies how to correct potential negative eigenvalues
from the conversion of phylogenetic distances into Principal
Coordinates: \code{"none"} (the default) indicates that no correction
is applied, particularly if H and S are ultrametric; \code{"sqrt.D"}
takes the element-wise square-root of the phylogenetic distances;
\code{"lingoes"} and \code{"cailliez"} apply the classical Lingoes
and Cailliez corrections, respectively.}

\item{percentile}{Percentile to evaluate (\emph{p}). Default is
\code{0.01} (1\\\%).}

\item{res.fq}{Determines whether a correction to avoid one-to-one
associations being overrepresented in the percentile evaluated.
If \code{TRUE} (default) a residual frequency value (observed -
expected frequency) is computed for each host-symbiont association.}

\item{strat}{Flag indicating whether execution is to be  \code{"sequential"}
or \code{"parallel"}. Default is \code{"sequential"},
resolves \R expressions sequentially in the current \R
process. If \code{"parallel"} resolves \R expressions in parallel in
separate \R sessions running in the background.}

\item{cl}{Number of cluster to be used for parallel computing.
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}
returns the number of clusters available.
Default is \code{cl = 1} resulting in \code{"sequential"} execution.}
}
\value{
A dataframe with host-symbiont associations in rows. The first and
second columns display the names of the host and symbiont terminals,
respectively. The third column designates the host-symbiont
association by pasting the names of the terminals, and the fourth
column displays the frequency of occurrence of each host-symbiont
association in \emph{p}. If \code{res.fq = TRUE}, column 5 displays
the corrected frequencies as a residual.
}
\description{
Prunes the host (H) and symbiont (S) phylogenies to conform with trimmed
matrices and computes the given global fit method, Geodesic distances (GD),
Procrustes Approach to Cophylogeny (PACo) or ParaFit (Legendre et al. 2002)
between the pruned trees. Then, determines the frequency or corrected
residual of each host-symbiont association occurring in a given percentile
of cases that maximize phylogenetic congruence.
}
\section{NOTE}{

If the \code{node.label} object in both trees contains NAs or empty
values (i.e. no numeric value). All nodes should have a value. Else
remove node labels within the \code{"phylo"} class tree
with \code{tree$node.label <- NULL}. For more details, see
\code{\link[distory:dist.multiPhylo]{distory::dist.multiPhylo()}}
}

\examples{
data(nuc_pc)
N = 1 #for the example, we recommend 1e+4 value
n = 15
NPc <- max_cong(np_matrix, NUCtr, CPtr, n, N, method = "paco",
                symmetric = FALSE, ei.correct = "sqrt.D",
                percentile = 0.01, res.fq = FALSE)

}
