% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc_mat.R
\name{assoc_mat}
\alias{assoc_mat}
\title{Create an host-symbiont association matrix}
\usage{
assoc_mat(hs)
}
\arguments{
\item{hs}{A two-columns matrix or data frame representing associations
between hosts (column 1) and symbionts (column 2) species.}
}
\value{
An association binary matrix, with hosts in rows and symbionts in
columns, sorted alphabetically.
}
\description{
Creates a binary host-symbiont association matrix from a two-columns matrix
or data frame of host-symbiont associations.
}
\examples{
\donttest{
data(nuc_cp)
NTaxa <- sort(NUCtr$tip.label)
CPTaxa <- sort(CPtr$tip.label)

NC <- assoc_mat(data.frame(NTaxa, CPTaxa))
}

}
