% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_iqr.R
\name{weighted.iqr}
\alias{weighted.iqr}
\title{Weighted inter-quantile range}
\usage{
weighted.iqr(x, w = rep(1, length(x)), rang = c(0.25, 0.75))
}
\arguments{
\item{x}{(numeric vector) Variable of interest for which to compute the inter-quantile range}

\item{w}{(numeric vector) Vector with the weights}

\item{rang}{(numeric vector) Two numbers between 0 and 1 indicating the desired inter-quantile range}
}
\value{
Scalar containing the inter-quantile range
}
\description{
Computes the weighted inter-quantile range of a numeric vector.
}
\examples{
weighted.iqr(x = mtcars$mpg, w = mtcars$wt,  rang = c(.5,.9))
  
}
