% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_stick_plot.R
\name{create_stick_plot}
\alias{create_stick_plot}
\title{create_stick_plot}
\usage{
create_stick_plot(
  df = NULL,
  base_val = 0,
  aes_x = NULL,
  aes_y = NULL,
  aes_color = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  x_major_date_breaks = waiver(),
  x_date_labels = waiver(),
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  axis_text_size = 11,
  line_color = "black",
  line_width = 0.8,
  line_type = "solid",
  line_alpha = 1,
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  panel_color = "white",
  panel_border_color = "black",
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 1.5,
  legend_key_height = 1.5,
  legend_key_backgrd = "white",
  bold_y = NULL,
  bold_y_color = "black",
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The required target data frame from which the "stick" lines are drawn.}

\item{base_val}{A numeric that sets the base value from which the "stick" originates.
The default value is 0.}

\item{aes_x}{The required x axis variable name from 'df'. Can be a continuous numeric/Date/POSIXct or discrete factor variable.}

\item{aes_y}{The required y axis numeric variable name from 'df' and controls the height of
individual "sticks".}

\item{aes_color}{Sets the variable name from 'df' for the aesthetic mapping for color.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default) then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{x_limits}{Depending on the class of 'aes_x', a numeric/Date/POSIXct 2 element vector that sets the minimum
and maximum for the x axis. Use NA to refer to the existing minimum and maximum.}

\item{x_major_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that
defines the exact major tic locations along the x axis.}

\item{x_minor_breaks}{Depending on the class of 'aes_x', a numeric/Date/POSIXct vector or function that defines
the exact minor tic locations along the x axis.}

\item{x_labels}{A character vector with the same length as 'x_major_breaks', that labels the major tics.}

\item{x_major_date_breaks}{If the class of 'aes_x' is Date/POSIXct, a string containing the number and date
unit for major breaks. Examples: "1 year", "4 sec", "3 month", "2 week".}

\item{x_date_labels}{If the class of 'aes_x' is Date/POSIXct, a string containing the format codes, the
strftime format, for the date. Examples: \code{\%Y-\%m}, \code{\%Y/\%b/\%d}, \code{\%H-\%M-\%S}}

\item{y_limits}{A numeric 2 element vector that sets the minimum and  maximum for the y axis.
Use NA to refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_labels}{A character vector with the same length as 'y_major_breaks', that labels the major tics.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{line_color}{A string that sets the color attribute of the lines.}

\item{line_width}{A numeric value that sets the width of lines.}

\item{line_type}{A string that sets the linetype. The default is "solid".}

\item{line_alpha}{A numeric value that sets the degree of color alpha attribute for the lines.}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}

\item{bold_y}{A numeric that plots a bold horizontal line at this y value.}

\item{bold_y_color}{A string that sets the bold horizontal line color. Default is "black".}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when NA's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function wraps a ggplot2 geom_linerange to produce a "stick" plot.
  Function returns a plot object showing vertical/horizontal lines that run from a base value to
  a measurement value. Options are provided for scaling.
}
\examples{
library(ggplot2)
library(RplotterPkg)

RplotterPkg::create_stick_plot(
  df = RplotterPkg::air_passengers,
  aes_x = "time",
  aes_y = "value",
  title = "Monthly Totals of International Airline Passengers",
  subtitle = "1949 - 1960 (classic Box & Jenkins)",
  x_title = "Time",
  y_title = "Totals",
  x_major_date_breaks = "1 year",
  x_date_labels = "\%Y",
  rot_y_tic_label = TRUE,
  show_minor_grids = FALSE,
  bold_y = 0.0
)

}
