% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnvd3.R
\name{hMultiBarChart}
\alias{hMultiBarChart}
\title{Horizontal multibar chart}
\usage{
hMultiBarChart(
  data,
  formula,
  by,
  palette = "viridis",
  xAxisTitle = NULL,
  yAxisTitle = NULL,
  margins = list(b = 100, l = 100),
  duration = 1300,
  groupSpacing = 0.1,
  xAxisTitleDistance = 25,
  yAxisTitleDistance = -5,
  yAxisShowMaxMin = FALSE,
  yAxisTickFormat = ".0f",
  nticks = 5,
  xLabelsFontSize = "1rem",
  yLabelsFontSize = "1rem",
  showValues = FALSE,
  tooltipFormatters = list(value = NULL, header = NULL, key = NULL),
  tooltipTransitions = TRUE,
  tooltipShadow = TRUE,
  width = "100\%",
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{data}{dataframe containing the data used for the chart}

\item{formula}{a two-sided formula like \code{y ~ x}, where \code{"x"} and
\code{"y"} are two column names of \code{data}}

\item{by}{string, the "by" variable; must be a column name of \code{data}}

\item{palette}{this can be either the name of a viridis color palette, e.g.
\code{"viridis"}, \code{"cividis"} or \code{"turbo"}
(see \code{\link[viridisLite]{viridis}}), or a vector of colors, or a
function that takes an integer argument (the required number of colors)
and returns a character vector of colors (e.g. you can use
\code{\link[grDevices]{colorRampPalette}})}

\item{xAxisTitle}{a title for the x-axis; if \code{NULL}, the title is
taken from the \code{formula} argument}

\item{yAxisTitle}{a title for the y-axis; if \code{NULL}, the title is
taken from the \code{formula} argument}

\item{margins}{a named list defining the margins, with names \code{"t"},
\code{"r"}, \code{"b"} and \code{"l"}, for "top", "right", "bottom"
and "left" respectively; you can specify only certain margins in the list
to change just those parts}

\item{duration}{duration of the transition, a number of milliseconds}

\item{groupSpacing}{a number, controls the distance between groups of bars}

\item{xAxisTitleDistance}{a number, controls the distance between the
x-axis and its title}

\item{yAxisTitleDistance}{a number, controls the distance between the
y-axis and its title}

\item{yAxisShowMaxMin}{Boolean, whether to show the min and the max on
the y-axis}

\item{yAxisTickFormat}{a d3 formatting string for the y-axis; see
\href{https://d3-wiki.readthedocs.io/zh_CN/master/Formatting/#d3_format}{d3.format}}

\item{nticks}{integer, the number of ticks on the y-axis}

\item{xLabelsFontSize}{a CSS measure, the font size of the labels on the
x-axis}

\item{yLabelsFontSize}{a CSS measure, the font size of the labels on the
y-axis}

\item{showValues}{Boolean, whether to show the values next to the bars}

\item{tooltipFormatters}{formatters for the tooltip; each formatter must
be \code{NULL} for the default formatting, otherwise a JavaScript function
created with \code{\link{JS}}; there are three possible formatters
(see the example):
\describe{
  \item{value}{formatter for the y-value displayed in the tooltip}
  \item{header}{formatter for the tooltip header (this is the x-value)}
  \item{key}{formatter for the value of the 'by' variable}
}}

\item{tooltipTransitions}{Boolean, whether to style the tooltip with a
fade effect}

\item{tooltipShadow}{Boolean, whether to style the tooltip with a shadow}

\item{width}{width of the chart container, must be a valid CSS measure}

\item{height}{height of the chart container, must be a valid CSS measure}

\item{elementId}{an id for the chart container; commonly useless}
}
\value{
A htmlwidget displaying a grouped/stacked bar chart.
}
\description{
HTMLwidget displaying a horizontal multibar chart.
}
\examples{
library(Rnvd3)
dat <- aggregate(breaks ~ wool + tension, data = warpbreaks, mean)
levels(dat[["tension"]]) <- c("Low", "Medium", "High")

hMultiBarChart(
  dat, breaks ~ wool, "tension", yAxisShowMaxMin = TRUE,
  yAxisTitle = "Mean of breaks", yAxisTickFormat = ".01f"
)

# the axis titles are small, let's make them bigger
library(htmltools)
CSS <- HTML(
  ".nvd3 .nv-axis.nv-x text.nv-axislabel,
   .nvd3 .nv-axis.nv-y text.nv-axislabel {
     font-size: 1rem;
  }"
)
prependContent(
  hMultiBarChart(
    dat, breaks ~ wool, "tension", yAxisShowMaxMin = TRUE,
    yAxisTitle = "Mean of breaks", yAxisTickFormat = ".01f"
  ),
  tags$style(CSS)
)
}
