% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{FBbridge}
\alias{FBbridge}
\title{Simulation of fractional Brownian bridge}
\usage{
FBbridge(H, x_end, t_end, x_start = 0, N = 1000, plot = FALSE)
}
\arguments{
\item{H}{Hurst parameter which lies between 0 and 1.}

\item{x_end}{Value of the process at the terminating time point.}

\item{t_end}{Terminal time point.}

\item{x_start}{Value of the process at the initial time point.}

\item{N}{Number of time steps on the interval \code{[0,t_end]}.
Default set to 1000.}

\item{plot}{Logical: If \code{TRUE}, the realisation of the fractional Brownian bridge
is plotted in interactive sessions.}
}
\value{
A data frame where the first column is \code{t} and second
column is simulated values of the realisation of fractional Brownian bridge.
}
\description{
This function simulates a realisation of the fractional Brownian bridge
for a provided Hurst parameter over the time interval \code{[0,t_end]},
which has the initial value \code{x_start} and terminates at \code{x_end} with \code{N} time steps.
}
\examples{
FBbridge(H = 0.5, x_end = 2, t_end = 1,plot = TRUE)
}
\references{
Bianchi, S., Frezza, M., Pianese, A., Palazzo, A.M. (2022). Modelling
H-Volatility with Fractional Brownian Bridge. In: Corazza, M., Perna, C., Pizzi, C.,
Sibillo, M. (eds) Mathematical and Statistical Methods for Actuarial Sciences and Finance.
MAF 2022. Springer, Cham. \doi{doi:10.1007/978-3-030-99638-3_16}.
}
\seealso{
\code{\link{FBm}}, \code{\link{FGn}}, \code{\link{Bm}}, \code{\link{GHBMP}}, \code{\link{Bbridge}}
}
