% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizations.R
\name{rankitXform}
\alias{rankitXform}
\title{Rankit Transformation}
\usage{
rankitXform(sample)
}
\arguments{
\item{sample}{The input data (vector)}
}
\value{
The Rankit-transformed data (vector)
}
\description{
This function transforms data via the Rankit, a member of the families of 'rank-based normalization
methods' and 'empirical normal quantile transformations' employed in both the social sciences
and quantitative genetics.
}
\examples{
values <- rnorm(100)
x <- rankitXform(values)
}
\references{
Soloman, S. R., & Sawilowsky, S. S. (2009). Impact of rank-based normalizing transformations on the accuracy of test scores. Journal of Modern Applied Statistical Methods, 8(2), 9.

            Peng, B., Robert, K. Y., DeHoff, K. L., & Amos, C. I. (2007, December). Normalizing a large number of quantitative traits using empirical normal quantile transformation. In BMC proceedings (Vol. 1, No. 1, p. S156). BioMed Central. doi: 10.1186/1753-6561-1-s1-s156

            Bliss, C. I., Greenwood, M. L., & White, E. S. (1956). A rankit analysis of paired comparisons for measuring the effect of sprays on flavor. Biometrics, 12(4), 381-403.
}
