% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_Tests.R
\name{DPTest}
\alias{DPTest}
\title{D'agostino Pearson Omnibus Test}
\usage{
DPTest(data, alpha = 0.05, j = 1, warn = T)
}
\arguments{
\item{data}{Data of a univariate distribution for which the test statistic is computed
(vector)}

\item{alpha}{The two-sided decision threshold used for hypothesis-testing}

\item{j}{The # hypotheses tested; used to compute a Bonferonni correction, if applicable;
should remain at its default if multiple testing is not an issue (scalar)}

\item{warn}{Used for printing a warning message when testing is terminated for N < 8 (boolean)}
}
\value{
An object including the test statistic, p-value, and a significance flag (list)
}
\description{
This function computes the D'agostino Pearson omnibus test using adjusted Fisher-
Pearson skewness and kurtosis estimators.
}
\examples{
values <- rnorm(100)
x <- DPTest(data = values)
}
\references{
D'agostino, R. B., & Stephens, M. A. (1986). Goodness-of-fit-techniques (Vol. 68). CRC press.

            D’agostino, R. B., & Belanger, A. (1990). A Suggestion for Using Powerful and Informative Tests of Normality. The American Statistician, 44(4), 316–321. https://doi.org/10.2307/2684359

            Shreve, Joni N. and Donna Dea Holland . 2018. SAS® Certification Prep
            Guide: Statistical Business Analysis Using SAS®9. Cary, NC: SAS Institute Inc.
}
