% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_mixed.R
\name{model_mixed}
\alias{model_mixed}
\alias{model_mixed_gendata}
\alias{model_mixed_prob}
\alias{model_mixed_info}
\alias{model_mixed_lh}
\title{Mixed-format model}
\usage{
model_mixed_gendata(n_p, n_3pl = 0, n_gpcm = 0, n_grm = 0, n_c, ...)

model_mixed_prob(t, items, D = 1.702)

model_mixed_info(t, items, D = 1.702, combine = TRUE)

model_mixed_lh(u, t, items, D = 1.702, log = FALSE, combine = TRUE)
}
\arguments{
\item{n_p}{the number of test takers}

\item{n_3pl}{the number of 3pl items}

\item{n_gpcm}{the number of gpcm items}

\item{n_grm}{the number of grm items}

\item{n_c}{the number of score categories for polytomous items}

\item{...}{additional arguments}

\item{t}{ability parameters, a vector}

\item{items}{a list of '3pl', 'gpcm', and 'grm' items}

\item{D}{the scaling constant, default=1.702}

\item{combine}{\code{TRUE} to combine results from list to matrix}

\item{u}{the response data, a 2d matrix}

\item{log}{\code{TRUE} to return log-likelihood}
}
\value{
\code{model_mixed_gendata} returns a list of generated responses, ability paramters and items

\code{model_mixed_prob} returns a list of probabilities for '3pl', 'gpcm', and 'grm' items

\code{model_mixed_info} returns a list or matrix of information
}
\description{
Common computations and operations for the mixed format model
}
\examples{
# generate 10 3pl items, 5 gpcm items and 5 grm items
model_mixed_gendata(10, n_3pl=10, n_gpcm=5, n_grm=5, n_c=3)
# generate 5 gpcm items and 5 grm items, 4 score categories each
model_mixed_gendata(10, n_gpcm=5, n_grm=5, n_c=4)
# generate 5 people and 4 items of each type
with(model_mixed_gendata(n_p=5, n_3pl=4, n_gpcm=4, n_grm=4, n_c=3), 
     model_mixed_prob(t, items))
     
# generate 10 people and 5 gpcm and 5 grm items
with(model_mixed_gendata(n_p=10, n_gpcm=4, n_grm=4, n_c=3), 
     model_mixed_prob(t, items))
with(model_mixed_gendata(10, 4, 4, 4, 3), model_mixed_info(t, items)) 
with(model_mixed_gendata(10, 0, 4, 4, 3), model_mixed_info(t, items)) 
with(model_mixed_gendata(10, 4, 4, 4, 3), model_mixed_lh(u, t, items))
}
