% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{helpers}
\alias{helpers}
\alias{model_polytomous_3dindex}
\alias{model_polytomous_3dresponse}
\alias{hermite_gauss}
\alias{nr_iteration}
\alias{estimate_3pl_debug}
\alias{estimate_3pl_eval}
\alias{estimate_gpcm_debug}
\alias{estimate_gpcm_eval}
\alias{estimate_grm_debug}
\alias{estimate_grm_eval}
\title{Helper Functions}
\usage{
model_polytomous_3dindex(u)

model_polytomous_3dresponse(u)

hermite_gauss(degree = c("20", "11", "7"))

nr_iteration(param, free, dv, h_max, lr, bound)

estimate_3pl_debug(tracking, k)

estimate_3pl_eval(true_params, t, a, b, c, t_free, a_free, b_free, c_free)

estimate_gpcm_debug(tracking, k)

estimate_gpcm_eval(true_params, n_c, t, a, b, d, t_free, a_free, b_free,
  d_free)

estimate_grm_debug(tracking, k)

estimate_grm_eval(true_params, n_c, t, a, b, t_free, a_free, b_free)
}
\arguments{
\item{u}{the observed response, 2d matrix, values start from 0}

\item{degree}{the degree of hermite-gauss quadrature: '20', '11', '7'}

\item{param}{the parameter being estimated}

\item{free}{TRUE to free parameters, otherwise fix parameters}

\item{dv}{the first and second derivatives}

\item{h_max}{the maximum value of h}

\item{lr}{the learning rate}

\item{bound}{the lower and upper bounds of the parameter}

\item{tracking}{estimation tracking information}

\item{k}{the number of iterations in estimation}

\item{true_params}{a list of true parameters}

\item{t}{estimated ability parameters}

\item{a}{estimated discrimination parameters}

\item{b}{estimated difficulty parameters}

\item{c}{estimated guessing parameters}

\item{t_free}{TRUE to estimate ability parameters, otherwise fix}

\item{a_free}{TRUE to estimate discrimination parameters, otherwise fix}

\item{b_free}{TRUE to estimate difficulty parameters, otherwise fix}

\item{c_free}{TRUE to estimate guessing parameters, otherwise fix}
}
\description{
\code{model_polytomous_3dindex} creates indices extracting 3D stats

\code{model_polytomous_3dresponse} converts responses from 2D to 3D

\code{hermite_gauss} stores pre-computed hermite gaussian 
quadratures points and weights

\code{nr_iteration} updates the parameters using the Newton-Raphson method
}
\keyword{internal}
