% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_gpcm.R
\name{estimate_gpcm}
\alias{estimate_gpcm}
\alias{model_gpcm_eap}
\alias{model_gpcm_map}
\alias{model_gpcm_dv_Pt}
\alias{model_gpcm_dv_Pa}
\alias{model_gpcm_dv_Pb}
\alias{model_gpcm_dv_Pd}
\alias{model_gpcm_dv_jmle}
\alias{model_gpcm_jmle}
\alias{model_gpcm_dv_mmle}
\alias{model_gpcm_mmle}
\alias{model_gpcm_fitplot}
\title{Estimation of the Generalizaed Partial Credit Model}
\usage{
model_gpcm_eap(u, a, b, d, D = 1.702, priors = c(0, 1),
  bounds_t = c(-4, 4))

model_gpcm_map(u, a, b, d, D = 1.702, priors = c(0, 1),
  bounds_t = c(-4, 4), iter = 30, conv = 0.001)

model_gpcm_dv_Pt(t, a, b, d, D)

model_gpcm_dv_Pa(t, a, b, d, D)

model_gpcm_dv_Pb(t, a, b, d, D)

model_gpcm_dv_Pd(t, a, b, d, D)

model_gpcm_dv_jmle(u_ix, dvp)

model_gpcm_jmle(u, t = NA, a = NA, b = NA, d = NA, D = 1.702,
  iter = 100, nr_iter = 10, conv = 0.001, scale = c(0, 1),
  bounds_t = c(-4, 4), bounds_a = c(0.01, 2.5), bounds_b = c(-4, 4),
  bounds_d = c(-4, 4), priors = list(t = c(0, 1)), decay = 1,
  verbose = FALSE, true_params = NULL)

model_gpcm_dv_mmle(u_ix, quad, pdv)

model_gpcm_mmle(u, t = NA, a = NA, b = NA, d = NA, D = 1.702,
  iter = 100, nr_iter = 10, conv = 0.001, bounds_t = c(-4, 4),
  bounds_a = c(0.01, 2.5), bounds_b = c(-4, 4), bounds_d = c(-4, 4),
  priors = list(t = c(0, 1)), decay = 1, quad_degree = "11",
  score_fn = c("eap", "map"), verbose = FALSE, true_params = NULL)

model_gpcm_fitplot(u, t, a, b, d, D = 1.702, d0 = NULL, index = NULL,
  intervals = seq(-3, 3, 0.5))
}
\arguments{
\item{u}{the observed response matrix, 2d matrix}

\item{a}{discrimination parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{b}{difficulty parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{d}{category parameters, 2d matrix (fixed value) or NA (freely estimate)}

\item{D}{the scaling constant, 1.702 by default}

\item{priors}{a list of prior distributions}

\item{bounds_t}{bounds of ability parameters}

\item{iter}{the maximum iterations}

\item{conv}{the convergence criterion of the -2 log-likelihood}

\item{t}{ability parameters, 1d vector (fixed value) or NA (freely estimate)}

\item{u_ix}{the 3d indices}

\item{dvp}{the derivatives of P}

\item{nr_iter}{the maximum iterations of newton-raphson}

\item{scale}{the scale of theta parameters}

\item{bounds_a}{bounds of discrimination parameters}

\item{bounds_b}{bounds of location parameters}

\item{bounds_d}{bounds of category parameters}

\item{decay}{decay rate}

\item{verbose}{TRUE to print debuggin information}

\item{true_params}{a list of true parameters for evaluating the estimation accuracy}

\item{quad_degree}{the number of quadrature points}

\item{score_fn}{the scoring method: 'eap' or 'map'}

\item{d0}{insert an initial category value}

\item{index}{the indices of items being plotted}

\item{intervals}{intervals on the x-axis}
}
\value{
\code{model_gpcm_eap} returns theta estimates and standard errors in a list

\code{model_gpcm_map} returns theta estimates in a list

\code{model_gpcm_jmle} returns estimated t, a, b, d parameters in a list

\code{model_gpcm_mmle} returns estimated t, a, b, d parameters in a list

\code{model_gpcm_fitplot} returns a \code{ggplot} object
}
\description{
Estimate the GPCM using the joint or marginal 
maximum likelihood estimation

\code{model_gpcm_eap} scores response vectors using the EAP method

\code{model_gpcm_map} scores response vectors using the MAP method

\code{model_gpcm_jmle} estimates the parameters using the 
joint maximum likelihood estimation (JMLE) method

\code{model_gpcm_mmle} estimates the parameters using the 
marginal maximum likelihood estimation (MMLE) method
}
\examples{
with(model_gpcm_gendata(10, 40, 3), 
     cbind(true=t, est=model_gpcm_eap(u, a, b, d)$t))
with(model_gpcm_gendata(10, 40, 3), 
     cbind(true=t, est=model_gpcm_map(u, a, b, d)$t))
\donttest{
# generate data
x <- model_gpcm_gendata(1000, 40, 3)
# free calibration, 40 iterations
y <- model_gpcm_jmle(x$u, true_params=x, iter=40, verbose=TRUE)
}
\donttest{
# generate data
x <- model_gpcm_gendata(1000, 40, 3)
# free estimation, 40 iterations
y <- model_gpcm_mmle(x$u, true_params=x, iter=40, verbose=TRUE)
}
with(model_gpcm_gendata(1000, 20, 3), 
     model_gpcm_fitplot(u, t, a, b, d, index=c(1, 3, 5)))
}
\keyword{internal}
