% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{predict-forestry}
\alias{predict-forestry}
\alias{predict.forestry}
\title{predict-forestry}
\usage{
\method{predict}{forestry}(
  object,
  feature.new,
  aggregation = "average",
  seed = as.integer(runif(1) * 10000),
  ...
)
}
\arguments{
\item{object}{A `forestry` object.}

\item{feature.new}{A data frame of testing predictors.}

\item{aggregation}{How the individual tree predictions are aggregated:
`average` returns the mean of all trees in the forest; `weightMatrix`
returns a list consisting of "weightMatrix", the adaptive nearest neighbor
weights used to construct the predictions; "terminalNodes", a matrix where
the ith entry of the jth column is the index of the leaf node to which the
ith observation is assigned in the jth tree; and "sparse", a matrix
where the ith entry in the jth column is 1 if the ith observation in
feature.new is assigned to the jth leaf and 0 otherwise. In each tree the
leaves are indexed using a depth first ordering, and, in the "sparse"
representation, the first leaf in the second tree has column index one more than
the number of leaves in the first tree and so on. So, for example, if the
first tree has 5 leaves, the sixth column of the "sparse" matrix corresponds
to the first leaf in the second tree.}

\item{seed}{random seed}

\item{...}{additional arguments.}
}
\value{
A vector of predicted responses.
}
\description{
Return the prediction from the forest.
}
