% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPost.R
\name{getPost}
\alias{getPost}
\title{Extract information about a public Facebook post}
\usage{
getPost(post, token, n = 500, comments = TRUE, likes = (!reactions),
  reactions = FALSE, n.likes = n, n.comments = n, n.reactions = n,
  api = NULL)
}
\arguments{
\item{post}{A post ID}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token 
created with \code{fbOAuth}.}

\item{n}{numeric, maximum number of comments and likes to return.}

\item{comments}{logical, default is \code{TRUE}, which will return data frame
with comments to the post.}

\item{likes}{logical, default is \code{TRUE} unless reactions is true, which will return data frame
with likes for the post.}

\item{reactions}{logical, default is \code{FALSE}, which will return data frame with reactions (like, love, etc) for the post}

\item{n.likes}{numeric, maximum number of likes to return. Default is \code{n}.}

\item{n.comments}{numeric, maximum number of comments to return. Default is 
\code{n}.}

\item{n.reactions}{numeric, maximum number of reactions to return. Default is 
\code{n}.}

\item{api}{API version. e.g. "v2.8". \code{NULL} is the default.}
}
\description{
\code{getPost} retrieves information about a public Facebook post, including
list of comments and likes.
}
\details{
\code{getPost} returns a list with up to four components: \code{post}, 
\code{likes}, \code{comments}, and \code{reactions}. 
\code{post} contains information about the post: author, creation date, id, 
counts of likes, comments, and shares, etc.
\code{likes} is a data frame that contains names and Facebook IDs of all
the users that liked the post. 
\code{comments} is a data frame with information about the comments to 
the post (author, message, creation time, id). To download also the replies
to specific comments, see \code{\link{getCommentReplies}}. Note that the total
number of comments may be different from the number report in \code{comments_count}
if some comments have been deleted.
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting information about Facebook's Facebook Page
load("fb_oauth")
fb_page <- getPage(page="facebook", token=fb_oauth)
## Getting information and likes/comments about most recent post
post <- getPost(post=fb_page$id[1], n=2000, token=fb_oauth)
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}
\seealso{
\code{\link{getUsers}}, \code{\link{getPage}}, \code{\link{fbOAuth}}
}

