% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPageToken.R
\name{getPageToken}
\alias{getPageToken}
\title{Get a page access token}
\usage{
getPageToken(page, token)
}
\arguments{
\item{page}{A page ID or page name.}

\item{token}{the token (with scope 'manage_pages') of a user that has admin access to the page}
}
\value{
the page access token string
}
\description{
Gets a page access token that can be used to e.g. get insights for a page.
}
\examples{
\dontrun{
## Get a normal access token with manage_pages scope
token = fbOAuth(app_id, app_secret, scope="manage_pages")
## Get a page access token for a page
page_token = getPageToken(page, token)
## Get page insights
getInsights(page, token=page_token, metric = "page_impressions")
}
}

