% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LowPSD.R
\name{LowPSD}
\alias{LowPSD}
\title{Function to calculate the power spectral density (PSD)}
\usage{
LowPSD(series, plot = TRUE, min = 1/8, max = 1/2)
}
\arguments{
\item{series}{a numeric vector, with data for a regularly spaced time series.}

\item{plot}{logical. whether to draw the plot of log power vs. log frequency}

\item{min, max}{the optional values. Frequency range of power spectral density. The default value is 1/2 and 1/8 and cannot be set to a negative number}
}
\value{
a value of spectral exponent(beta) which the the slope of the  of the fitting line on plot of log power vs. log frequency
}
\description{
function to calculate the power spectral density (PSD) of a time series. Methods derived from A. Eke (2000) "Physiological time series: distinguishing fractal noises from motions" <doi:10.1007/s004249900135>.
}
\examples{
data("TestData")
Fs <- 50
Peaks <- find.peaks(Data[,2],Fs,lowpass=TRUE,freq=1,MovingAv=FALSE,
                    W=FALSE,filter=TRUE,threshold=0.05)
PP_interval=diff(Peaks[,1])/Fs
LowPSD(series=PP_interval,plot=TRUE,min=1/64, max=1/2)

}
\references{
Zhang T, Dong X, Chen C, Wang D, Zhang XD. RespirAnalyzer: an R package for continuous monitoring of respiratory signals.
}
