% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scTC_bpplot.R
\name{scTC_bpplot}
\alias{scTC_bpplot}
\title{scTC_bpplot: Post-trim breakpoint heatmap for scTrimClust results}
\usage{
scTC_bpplot(
  ...,
  trim_percent_vector,
  plot_title = "scTrimClust: Post-trim Breakpoint Heatmap",
  legend_title = "Percent markes\\nof non-trimmed",
  color = brewer.pal(n = 11, name = "RdYlBu")
)
}
\arguments{
\item{...}{Two or more data.frames/tibbles containing marker genes from 'FindAllMarkers'.}

\item{trim_percent_vector}{Numeric vector of trim percentages.}

\item{plot_title}{Character string for the heatmap title.}

\item{legend_title}{Character string for the legend title.}

\item{color}{Color palette for the heatmap.}
}
\value{
A ComplexHeatmap object
}
\description{
Generates a heatmap showing the percentage overlap of marker genes between
the original (untrimmed) cluster markers and markers identified after trimming
at various percentages.
}
\details{
scTC_bpplot compares marker genes between the original (untrimmed) clustering
and trimmed versions. For each cluster, it calculates what percentage of the
original markers are retained at each trim level. Clusters are ordered by the
number of markers in the original (untrimmed) results.

At least two data.frames/tibbles containing marker genes from 'FindAllMarkers'
(from the 'Seurat' package) should be provided to \emph{...} as input.
The first data frame should be the original (untrimmed) results, followed by
trimmed results.

\emph{trim_percent_vector} must be a numeric vector of trim percentages
corresponding to each input data frame (e.g., c(0,10,20,30,40) for untrimmed,
10%, 20%, 30%, and 40% trimmed results). Must have same length as number of
input data.frames/tibbles.
}
\examples{
\dontrun{
scTC_bpplot(
  covid_markers = RepeatedHighDim:::covid_markers,
  robust_covid_markers = RepeatedHighDim:::robust_covid_markers,
  robust_covid_markers_02trim = RepeatedHighDim:::robust_covid_markers_02trim,
  robust_covid_markers_03trim = RepeatedHighDim:::robust_covid_markers_03trim,
  robust_covid_data = RepeatedHighDim:::robust_covid_data,
  trim_percent_vector = c(0, 10, 20, 30, 40),
  plot_title = "CLR, nPCs:5, nFeatures:1000",
  legend_title = "Percent markers of non-trimmed"
)
}

}
