% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mttf}
\alias{mttf}
\title{Mean Time To Failure (MTTF)}
\usage{
mttf(failures, totalTime)
}
\arguments{
\item{failures}{Numeric scalar or numeric vector of failure counts (non-negative).}

\item{totalTime}{Numeric scalar or numeric vector of total operating times.}
}
\value{
Numeric scalar: MTTF. If number of failures is zero, returns Inf (with a warning).
}
\description{
For non-repairable items MTTF = total operating time / number of failures. The
MTTF is the expected time to the first failure. It is commonly used for non-repairable items.
The behavior implemented is the same as mtbf here; keep separate name for semantic clarity.
}
\examples{
mttf(5, 1000)
mttf(c(2,3), c(500,500))
}
