% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reparto_Escanos.R
\name{reparto_div}
\alias{reparto_div}
\title{Allocation using divisor methods}
\usage{
reparto_div(candidaturas, votos, escanos, metodo)
}
\arguments{
\item{candidaturas}{A text vector containing the name of the parties.}

\item{votos}{An integer vector with the votes of each party.}

\item{escanos}{An integer number stating the total number of seats to be allocated.}

\item{metodo}{It is the method to be used. The allowd values are:
c("dhondt","saint_lague","saint_lague_Mod",
"Danish","Imperiali","Hill_Huntington",
"Dean")}
}
\value{
Returns a data.frame with the names of the political parties and the number of Members
allocated with the chosen method.
}
\description{
This option uses various methods whose main common feature is that the number of
votes obtained by the political candidatures are divided by a series of numbers. The name of the
method used depends on the numbers which compose that series. In this sense, the methods
admitted are the following:

\enumerate{
\item \bold{dhont}. It is the so-called D'Hondt Law and is the procedure used in Spain
to transform votes into seats in the Congress of Deputies. The series of numbers used
as a quotient are the integer numbers: 1,2,...n , where n is the number of seats to be distributed.

\item \bold{saint_lague}. This is the Sainte Lagüe method, Webster's method or odd-numbered divisors.
The set of divisors is formed by the odd numbers, that is {1,3,..,2n+1}.

\item \bold{saint_lague_Mod}.It is the modified Sainte Lagüe method, a variant of the Sainte Lagüe
method, according to which the initial quotient is v/1.4 and once each party has a seat the
standard formula v/(2n+1) is used.

\item \bold{Danish}. In this method the divisors go from three to three units, that is to say
it is formed by the numbers: 1,4,7,10,13... and the n-th divisor would be 3*n-2.

\item \bold{Imperiali}. The divisors are the positive integers but starting from number 2
onwards, that is: 2,3,4,...

\item \bold{Hill_Huntington}. In this case the divisors are formed by the following sequence:
sqrt(2),sqrt(6),sqrt(12),...., sqrt(n*(n+1))

\item \bold{Dean}.The set of divisors consists of the following numbers:
4/3, 12/5, 24/7,40/0,....,(2\emph{n)(n+1)/(2}n+1)

}
In all cases the value of q is rounded up to the nearest integer.
}
\examples{

reparto_div(c("A","B","C","D","E"),c(340000,280000,160000,60000,15000),7,metodo="dhondt")
reparto_div(c("A","B","C","D"),c(340000,280000,160000,60000),7,metodo='saint_lague')
reparto_div(c("A","B","C","D"),c(340000,280000,160000,60000),7,metodo='saint_lague_Mod')
reparto_div(c("A","B","C","D"),c(340000,280000,160000,60000),7,metodo='Danish')
reparto_div(c("A","B","C","D"),c(340000,280000,160000,60000),7,metodo='Imperiali')
reparto_div(c("A","B","C","D"),c(340000,280000,160000,60000),7,metodo='Dean')


}
\seealso{
\code{\link{Restos_Mayores}} for allocation using the largest remainder method

\url{https://en.wikipedia.org/wiki/D\%27Hondt_method} on Wikipedia

\url{https://bit.ly/3aEidM9} on Wikipedia.

\url{https://bit.ly/2Q0a0u0} on the internet.
}
