% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarizacion.R
\name{polarizacion}
\alias{polarizacion}
\title{Dimensionality of voting. Polarization index. ( PP )}
\usage{
polarizacion(datos, Tipo = 1)
}
\arguments{
\item{datos}{It is a data.frame with three columns: the first one contains the name of the political parties.
The second contains the value of the ideological thinking location (scale from 1 to 10), and the third the
number of votes obtained (electoral polarization), or the number of seats obtained (parliamentary polarization).}

\item{Tipo}{It can take either value 1 or 2. 1 To indicate that the weighted formula is obtained but by
calculating the distance to the weighted mean squared. If this parameter takes the value of 2, the
formula that gets the absolute value of the differences to the weighted average will be used instead.}
}
\value{
Returns a numeric value of this indicator.
}
\description{
This dimension is one of the most important in democratic systems, as it explains part
of the stability and bankruptcy problems of democracies. The index that is calculated with this
function needs the data of the ideological location of the parties, which are difficult to obtain, and
that is something as simple as a scale of values between 1 and 10, in such a way that the closer to 1 the
valuation of a political party is, it will be more classified as left-wing ideology, and the opposite case will
occur when a political formation has a rating at the other end of the scale. The value obtained for this
ideological position will be placed in the second column of the data.frame called  "data", which is
the first parameter that is passed to the function and whose structure is explained later, in the
parameters section. If the indicator takes a value close to zero, it means there will be
no polarization, and the polarization will increase as the indicator takes higher values.

In this section the weighted polarization index is calculated. For its calculation the following
formulas will be used:

\deqn{Pp=\sum_{i=1}^{n}p_{i}(x_{i}-\overline{x}_{p})^{2}}{Pp = sum(p_j*(x_j-mean(x_p))^2)}
for \eqn{i = 1, 2, \ldots,n}

\deqn{Pp2=\sum_{i=1}^{n}p_{i}\left|x_{i}-\overline{x}_{p}\right|}{Pp2 = sum(p_j*|x_j-mean(x_p)|)}
for \eqn{i = 1, 2, \ldots,n}
}
\examples{
d <- data.frame(partidos=c("RN","PDC","PS","PPD","UDI","PRSC","otros"),
 ubicacion=c(6.36,5.31,2.73,4.13,7.04,4.00,5.33),
 c(19,20,15,21,33,7,5))
polarizacion(d,Tipo = 2)

}
