% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{nepMolinar}
\alias{nepMolinar}
\title{Voting Dimension Index. Molinar's index of number of parties (electoral and parliamentary) (NP)}
\usage{
nepMolinar(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns a dataframe, with the columns "electoral" and "parliamentary" to store the value of
the index of the Number of parties of Molinar in the electoral or the parliamentary way respectively.
}
\description{
This indicator proposed by Molinar (1991), attempts to evaluate the relevant number
of parties that actually exist in an electoral process. It can be said that this index shows a
better performance than the indexes of the number of parties and hyperfractionality, both in the
weighting it gives to the winning party and in the difference between the first and second parties,
as well as in the degree of concentration of the minority parties. The formula used for the
calculation of this index is the following:

\deqn{NP=1+N^{2}\sum_{i=2}p_{i}^{2}}{NP=1+N^2*sum(pi^2, for i>=2)}
for \eqn{i =  2, \ldots,n } and p_i the percentages (as parts per unit) of votes or seats of the party i
}
\examples{

nepMolinar(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))

}
