% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{hiper}
\alias{hiper}
\title{Voting Dimension Index. Hyperfractionality index (electoral and parliamentary) (I)}
\usage{
hiper(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns a dataframe, with the columns "electoral" and "parliamentary" to store the value of
the hyperfractionality index in the electoral or parliamentary way respectively
}
\description{
The hyperfractionality index, proposed by Kesselman (1996) and Wilden (1991),
is another indicator used to measure the number of parties that are relevant in any type
of election. This index is very sensitive to the presence of small
parties since it gives them more relevance than they really have. The mathematical formula
used to calculate the value of this index is as follows:

\deqn{I=exp(-\sum p_{i}ln(p_{i}))}{I=exp(-sum(pi*ln(pi)))}
for \eqn{i = 1, 2, \ldots,n } and p_i>0 the percentages (as parts per unit) of votes or seats of the party i
}
\examples{

hiper(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))

}
