% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{Rae_corregido}
\alias{Rae_corregido}
\title{Corrected Rae's disproportionality index ("Rco")}
\usage{
Rae_corregido(votes, seats, correc = 0.5)
}
\arguments{
\item{votes}{It is a vector of integers, containing ALL the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing ALL the seats obtained by each of the candidates.}

\item{correc}{This is a decimal value that indicates the minimum percentage of votes needed in order to
be taken into account for the formula. By default its value is 0.5.}
}
\value{
Returns the value obtained for the index
}
\description{
It was Rae himself who realised the problems in calculating the RAE index by taking
all parties into account. For this reason he reviewed the basis of the index and decided to exclude
from the calculation all parties that did not reach 0.5 percent of the votes. The function created
to calculate this index takes this corrective value by default, although it is allowed to enter another value,
as it can be seen in the example below.

To compute its value, the integer vectors corresponding to the votes obtained by each party and
their seats must be provided as parameters of the formula. The R code will be in charge of
calculating the corresponding percentages in order to obtain the index.
}
\examples{
Rae_corregido(c(1200, 30, 4000),c(10,6,8), correc = 1)
Rae_corregido(c(1200, 30, 4000),c(10,6,8))

}
