% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{Gallagher}
\alias{Gallagher}
\title{Gallagher's disproportionality index of minimum squares - 1991 (Gcm)}
\usage{
Gallagher(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns the value obtained for the index
}
\description{
The Gallagher's electoral disproportionality index of minimum squares uses
a somewhat more elaborate formula than the previous indices (R, LH), for which it calculates
the differences squared between the votes and seats, adds them up and divides the result by
two and then calculates its square root. It therefore gives appropriate weight to the
distortions of disproportionality. Its mathematical formula is as follows:
\deqn{Gcm=\sqrt{\frac{\sum(V_{i}-E_{i})^{2}}{2}}}{Gcm =sqrt(sum(Vi-Ei)^2*(1/2)) }
for \eqn{i =  1, 2, \ldots,n}
}
\examples{

Rae(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))
Gallagher(c(3947,3189,1971,466,345,82),c(184,99,44,10,1,0))


}
