% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Indelec.R
\name{DesAgregadosIndi}
\alias{DesAgregadosIndi}
\title{Utilities. Obtaining electoral indicators from disaggregated data}
\usage{
DesAgregadosIndi(
  Ano = 0,
  Mes = "",
  RutaDescarga = "",
  Auto = TRUE,
  datos_v = "",
  datos_d = ""
)
}
\arguments{
\item{Ano}{Required only for automatic procedure. It is the year of the electoral process that
the user wants to study. It must be a four-digit numerical value.}

\item{Mes}{Required only for automatic procedure.is the month of the electoral process, it must
be a string composed of two characters, associated with the month in which the elections were held.}

\item{RutaDescarga}{Required only for automatic procedure. must be a string indicating the local path
of the user's computer where to download the file from the Spanish Ministry of Home Office (MIR).
This file is then automatically deleted once the process is completed. The user has to bear in mind that this path must indicate a
place where R has read and write permission, otherwise the process will not be completed.}

\item{Auto}{It can take the logical values TRUE or FALSE. By default it has the value TRUE to indicate
that the user wants the automatic procedure. In the case of wanting a manual procedure, this parameter will take the FALSE value.}

\item{datos_v}{Required only for manual procedure. is a data.frame with at least three columns.
The first column contains the name of the geographical unit that groups the elements of the
third column, which in the case of Spain can initially be the name of the Autonomous Community.
The second column is alphabetical and contains the code of the geographical unit appearing in
the third column. In the case of Spain, normally the province code will be the one of the Spanish
National Statistics Institute (INE). The third column is also of character format and contains the
name of the electoral disctric, in the case of Spain this will normally be the name of the province.
The fourth and following columns will refer to a specific political party, and the name of the column
is recommended to coincide with the acronym of the political party in question.}

\item{datos_d}{Required only for manual procedure. It is a data.frame with the same structure as 'datos_v',
the only thing that from the fourth column onwards will contain the seats obtained by each political party
for each of the territorial units included in the rows. \strong{The order of these columns} must be the same as
that of 'datos_v' to include the votes.}
}
\value{
The output consists of a list that contains two lists:
\enumerate{
\item The fisrt list contains the layer of Autonomous Communities or geographical grouping units. There is a list
for each Autonomous Community or grouping unit. The order of this list corresponds to the order in which
the Autonomous Communities or grouping units appear in the input data.frame. After selecting an Autonomous
Community or grouping unit, another list is obtained with the same four elements that
contained the output of the function 'AgregadosIndi()' but for that specific geographical grouping unit.
\item The second list contains the layer of provinces or disaggregated electoral districts. In this case,
a list is also obtained for each province or disaggregated unit, with the identifier equal to that
shown for the province or disaggregated unit in the input files. Finally, for each province, a list
is obtained with the four elements that were available with the output of the function 'AgergadosIndi()'.
}
}
\description{
With this function, the same results will be obtained as with
the 'AgregadosIndi()' function, but for each of the regions listed in the
data provided. Specifically, when downloading data from the Spanish Ministry
of Home Office, the indicated data will be obtained both for each Autonomous
Community and for each province. The format of the output resulting from this
function is indicated below.

\strong{IMPORTANT NOTE:} Again, data can be obtained automatically or provided manually.
}
\examples{
d2<-DesAgregadosIndi(2019,"04",RutaDescarga = "F:/")


}
