% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Electoral_index.R
\name{Loos_Hanby}
\alias{Loos_Hanby}
\title{Disproportionality index of Loosemore and Hanby - 1971 ("LH")}
\usage{
Loos_Hanby(votes, seats)
}
\arguments{
\item{votes}{It is a vector of integers, containing the votes of all the candidates.}

\item{seats}{It is a vector of integers, containing the seats obtained by each of the candidates.}
}
\value{
Returns the value obtained for the index
}
\description{
Loosemore and Hanby disproportionality index ( 1971 ) aims to address the difficulties
encountered with the Rae index. To calculate this disproportionality index, the absolute values of
the differences between votes and seats are added together and the result is divided by two. The
specific formula used is as follows:
'\deqn{LH=\frac{\sum_{i=1}^{n}|E_{i}-V_{i}|}{2}}{LH = (1/2)*sum(|Vi-Ei|)}
for \eqn{i = 1, 2, \ldots,n}
}
\examples{
Loos_Hanby(c(1200, 30, 4000),c(10,6,8))

}
