% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dBS2.R
\name{dBS2}
\alias{dBS2}
\alias{pBS2}
\alias{qBS2}
\alias{rBS2}
\alias{hBS2}
\title{The Birnbaum-Saunders distribution - Santos-Neto et al. (2014)}
\usage{
dBS2(x, mu = 1, sigma = 1, log = FALSE)

pBS2(q, mu = 1, sigma = 1, lower.tail = TRUE, log.p = FALSE)

qBS2(p, mu = 1, sigma = 1, lower.tail = TRUE, log.p = FALSE)

rBS2(n, mu = 1, sigma = 1)

hBS2(x, mu, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{parameter.}

\item{sigma}{parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
P[X <= x], otherwise, P[X > x].}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dBS2} gives the density, \code{pBS2} gives the distribution 
function, \code{qBS2} gives the quantile function, \code{rBS2}
generates random deviates and \code{hBS2} gives the hazard function.
}
\description{
Density, distribution function, quantile function, 
random generation and hazard function for the 
Birnbaum-Saunders distribution with
parameters \code{mu} and \code{sigma}.
}
\details{
The Birnbaum-Saunders with parameters \code{mu} and \code{sigma}
has density given by

\eqn{f(x) = \frac{\exp(\sigma/2)\sqrt{\sigma+1}}{4\sqrt{\pi\mu}x^{3/2}} \left[ x + \frac{\mu\sigma}{\sigma+1} \right] \exp\left( \frac{-\sigma}{4} \left(\frac{x(\sigma+1)}{\mu\sigma}+\frac{\mu\sigma}{x(\sigma+1)} \right) \right) }

for \eqn{x>0}, \eqn{\mu>0} and \eqn{\sigma>0}. In this 
parameterization 
\eqn{E(X)=\mu} and 
\eqn{Var(X)=(\mu\sigma)^2(1+5\sigma^2/4)}. The functions 
proposed here corresponds to the 
parameterization proposed by 
Santos-Neto et al. (2014).
}
\examples{
#Example 1
#Plotting the mass function for different parameter values
curve(dBS2(x, mu=1.0, sigma=100), 
      from=0.001, to=5,
      ylim=c(0, 3), 
      col="royalblue1", lwd=2, 
      main="Density function",
      xlab="x", ylab="f(x)")
curve(dBS2(x, mu=1.5, sigma=100),
      col="tomato", 
      lwd=2,
      add=TRUE)
curve(dBS2(x, mu=2.0, sigma=100),
      col="seagreen",
      lwd=2,
      add=TRUE)
legend("topright", legend=c("mu=1.0, sigma=100", 
                            "mu=1.5, sigma=100",
                            "mu=2.0, sigma=100"),
       col=c("royalblue1", "tomato", "seagreen"), lwd=2, cex=0.6)


curve(dBS2(x, mu=1, sigma=2), 
      from=0.001, to=2,
      ylim=c(0, 1.1), 
      col="royalblue1", lwd=2, 
      main="Density function",
      xlab="x", ylab="f(x)")
curve(dBS2(x, mu=1, sigma=5),
      col="tomato", 
      lwd=2,
      add=TRUE)
curve(dBS2(x, mu=1, sigma=10),
      col="seagreen",
      lwd=2,
      add=TRUE)
legend("topright", legend=c("mu=1, sigma=2", 
                            "mu=1, sigma=5",
                            "mu=1, sigma=10"),
       col=c("royalblue1", "tomato", "seagreen"), lwd=2, cex=0.6)


# Example 2
# Checking if the cumulative curves converge to 1
curve(pBS2(x, mu=0.5, sigma=0.5), 
      from=0.001, to=15,
      ylim=c(0, 1), 
      col="royalblue1", lwd=2, 
      main="Cumulative Distribution Function",
      xlab="x", ylab="f(x)")
curve(pBS2(x, mu=1, sigma=0.5),
      col="tomato", 
      lwd=2,
      add=TRUE)
curve(pBS2(x, mu=1.5, sigma=0.5),
      col="seagreen",
      lwd=2,
      add=TRUE)
legend("bottomright", legend=c("mu=0.5, sigma=0.5", 
                               "mu=1.0, sigma=0.5",
                               "mu=1.5, sigma=0.5"),
       col=c("royalblue1", "tomato", "seagreen"), lwd=2, cex=0.5)

# Example 3
# The quantile function
p <- seq(from=0, to=0.999, length.out=100)
plot(x=qBS2(p, mu=2.3, sigma=1.7), y=p, xlab="Quantile",
     las=1, ylab="Probability", main="Quantile function ")
curve(pBS2(x, mu=2.3, sigma=1.7), 
      from=0, add=TRUE, col="tomato", lwd=2.5)

# Example 4
# The random function
x <- rBS2(n=10000, mu=2.5, sigma=100)
hist(x, freq=FALSE)
curve(dBS2(x, mu=2.5, sigma=100), from=0, to=10, 
      add=TRUE, col="tomato", lwd=2)

# Example 5
# The Hazard function
curve(hBS2(x, mu=20, sigma=0.5), from=0.001, to=100,
      col="tomato", ylab="Hazard function", las=1)

}
\references{
Santos-Neto, M., Cysneiros, F. J. A., Leiva, V., & Barros, M. 
(2014). A reparameterized Birnbaum–Saunders distribution 
and its moments, estimation and applications. 
REVSTAT-Statistical Journal, 12(3), 247-272.
}
\seealso{
\link{BS2}.
}
