% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MW.R
\name{MW}
\alias{MW}
\title{The Modified Weibull family}
\usage{
MW(mu.link = "log", sigma.link = "log", nu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a MW distribution in the \code{gamlss()} function.
}
\description{
#' The Modified Weibull distribution
}
\details{
The Modified Weibull distribution with parameters \code{mu}, 
\code{sigma} and \code{nu} has density given by

\eqn{f(x) = \mu (\sigma + \nu x) x^{\sigma - 1} \exp(\nu x) \exp(-\mu x^{\sigma} \exp(\nu x)),}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma \geq 0} and \eqn{\nu \geq 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu
y <- rMW(n=100, mu = 2, sigma = 1.5, nu = 0.2)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, family= 'MW',
               control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))

# Example 2
# Generating random values under some model
n     <- 200
x1    <- rpois(n, lambda=2)
x2    <- runif(n)
mu    <- exp(3 -1 * x1)
sigma <- exp(2 - 2 * x2)
nu    <- 0.2
x     <- rMW(n=n, mu, sigma, nu)

mod <- gamlss(x~x1, mu.fo=~x1, sigma.fo=~x2, nu.fo=~1, family=MW,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
coef(mod, what='nu')
}
\references{
Almalki, S. J., & Nadarajah, S. (2014). Modifications of the 
Weibull distribution: A review. Reliability Engineering & 
System Safety, 124, 32-55.

Lai, C. D., Xie, M., & Murthy, D. N. P. (2003). 
A modified Weibull distribution. 
IEEE Transactions on reliability, 52(1), 33-37.
}
\seealso{
\link{dMW}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
