% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIN.R
\name{LIN}
\alias{LIN}
\title{The Lindley family}
\usage{
LIN(mu.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a LIN distribution in the \code{gamlss()} function.
}
\description{
The function \code{LIN()} defines the Lindley distribution with only one parameter 
for a \code{gamlss.family} object to be used in GAMLSS fitting 
using the function \code{gamlss()}.
}
\details{
The Lindley with parameter \code{mu} has density given by

\eqn{f(x) = \frac{\mu^2}{\mu+1} (1+x) \exp(-\mu x),}

for x > 0 and \eqn{\mu > 0}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu
y <- rLIN(n=200, mu=2)

# Fitting the model
require(gamlss)
mod <- gamlss(y ~ 1, family="LIN")

# Extracting the fitted values for mu
# using the inverse link function
exp(coef(mod, what='mu'))

# Example 2
# Generating random values under some model
n <- 100
x1 <- runif(n=n)
x2 <- runif(n=n)
eta <- 1 + 3 * x1 - 2 * x2
mu <- exp(eta)
y <- rLIN(n=n, mu=mu)

mod <- gamlss(y ~ x1 + x2, family=LIN)

coef(mod, what='mu')

}
\references{
Lindley, D. V. (1958). Fiducial distributions and Bayes' theorem. 
Journal of the Royal Statistical Society. 
Series B (Methodological), 102-107.
}
\author{
Freddy Hernandez \email{fhernanb@unal.edu.co}
}
