% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_deeplearning.R
\name{autoencoder_detect}
\alias{autoencoder_detect}
\title{Autoencoder-based Changepoint Detection}
\usage{
autoencoder_detect(
  data,
  window_size = 50,
  latent_dim = 10,
  hidden_dims = c(32, 16),
  epochs = 100,
  batch_size = 32,
  threshold = NULL,
  contamination = 0.1,
  variational = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Numeric vector of time series data}

\item{window_size}{Size of sliding window (default: 50)}

\item{latent_dim}{Dimension of latent space (default: 10)}

\item{hidden_dims}{Hidden layer dimensions (default: c(32, 16))}

\item{epochs}{Training epochs (default: 100)}

\item{batch_size}{Batch size (default: 32)}

\item{threshold}{Threshold for anomaly detection. NULL for automatic
selection using 3-sigma rule.}

\item{contamination}{Expected proportion of anomalies for threshold
selection (default: 0.1)}

\item{variational}{Use Variational Autoencoder (default: FALSE)}

\item{verbose}{Show training progress (default: FALSE)}
}
\value{
List with:
\item{changepoints}{Detected changepoint locations}
\item{reconstruction_error}{Per-window reconstruction error}
\item{threshold}{Threshold used for detection}
\item{model}{Trained Keras model}
}
\description{
Detects changepoints by identifying regions where reconstruction error
is anomalously high, indicating the model (trained on normal patterns)
fails to reconstruct the data.
}
\examples{
\dontrun{
data <- c(rnorm(100), rnorm(100, mean = 3), rnorm(100))
result <- autoencoder_detect(data, window_size = 30)
plot(result$reconstruction_error, type = "l")
abline(v = result$changepoints, col = "red")
}
}
