% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadBib.R
\name{ReadBib}
\alias{ReadBib}
\title{BibLaTeX/BibTeX .bib file parser}
\usage{
ReadBib(
  file,
  .Encoding = "UTF-8",
  header = if (length(preamble)) paste(preamble, sep = "\\n") else "",
  footer = "",
  check = BibOptions()$check.entries
)
}
\arguments{
\item{file}{string; bib file to parse.}

\item{.Encoding}{encoding}

\item{header}{header of the citation list. By default this is made from the Preamble
entries found in the bib file.}

\item{footer}{footer of the citation list.}

\item{check}{\dQuote{error}, \dQuote{warn}, or logical \code{FALSE}.  What action
should be taken if an entry is missing required fields?  \code{FALSE} means no
checking is done, \dQuote{warn} means entry is added with an error.
\dQuote{error} means the entry will not be added.  See \code{\link{BibOptions}}.}
}
\description{
Parser for bibliography databases in the bib format containing either BibLaTeX or
BibTeX entries.
}
\note{
Date fields are parsed using the locale specified by
\code{Sys.getlocale("LC_TIME")}.  To read a bib file with character \sQuote{month}
fields in a language other than the current locale, \code{Sys.setlocale} should be
used to change \sQuote{LC_TIME}` to match the bib file before calling \code{ReadBib}.

Keys will be made unique by calling \code{\link[base]{make.unique}} with
\code{sep = ":"}.
}
\examples{
bib.text <- "@Manual{mclean2014,
  author = {Mathew William McLean},
  title = {Straightforward Bibliography Management in R Using the RefManager Package},
  note = {arXiv: 1403.2036 [cs.DL]},
  year = {2014},
  url = {https://arxiv.org/abs/1403.2036},
}"
tfile <- tempfile(fileext = ".bib")
writeLines(bib.text, tfile)
ReadBib(tfile)
unlink(tfile)
\dontrun{
    file.name <- system.file("Bib", "RJC.bib", package="RefManageR")
    bib <- ReadBib(file.name)
}
}
\seealso{
\code{\link[bibtex]{read.bib}} in package \code{bibtex}
}
\author{
McLean, M. W., based on code in \code{bibtex} package by Francois, R.
}
