% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateOneStepNumeric.R
\name{integrateOneStepNumeric}
\alias{integrateOneStepNumeric}
\title{Numeric Integration of One-step Function}
\usage{
integrateOneStepNumeric(
  object,
  newdata = NULL,
  w.lo = NULL,
  w.hi = NULL,
  Units = NULL,
  expansions = NULL,
  series = NULL,
  isPoints = NULL
)
}
\arguments{
\item{object}{Either an Rdistance fitted distance function
(an object that inherits from class "dfunc"; usually produced 
by a call to \code{\link{dfuncEstim}}), or a matrix of canonical 
distance function parameters (e.g., \code{matrix(exp(fit$par),1)}). 
If a matrix, each row corresponds to a 
distance function and each column is a parameter. The first column is 
the parameter related to sighting covariates and must be transformed 
to the "real" space (i.e., inverse link, which is \eqn{exp()}, must 
be applied outside this routine).  If \code{object} is a matrix, 
it should not have measurement units because
only derived quantities (e.g., ESW) have units; Rdistance function 
parameters themselves never have units.}

\item{newdata}{A data frame containing new values for 
the distance function covariates. If NULL and 
\code{object} is a fitted distance function, the  
observed covariates stored in
\code{object} are used (behavior similar to \code{\link{predict.lm}}).
Argument \code{newdata} is ignored if \code{object} is a matrix.}

\item{w.lo}{Minimum sighting distance or left-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function. 
Must have physical measurement units.}

\item{w.hi}{Maximum sighting distance or right-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function.
Must have physical measurement units.}

\item{Units}{Physical units of sighting distances if 
\code{object} is a matrix. Sighting distance units can differ from units 
of \code{w.lo} or \code{w.hi}.   Ignored if \code{object}
is a fitted distance function.}

\item{expansions}{A scalar specifying the number of terms 
in \code{series} to compute. Depending on the series, 
this could be 0 through 5.  The default of 0 equates 
to no expansion terms of any type.  No expansion terms 
are allowed (i.e., \code{expansions} is forced to 0) if 
covariates are present in the detection function 
(i.e., right-hand side of \code{formula} includes
something other than \code{1}).}

\item{series}{If \code{expansions} > 0, this string 
specifies the type of expansion to use. Valid values at 
present are 'simple', 'hermite', and 'cosine'.}

\item{isPoints}{Boolean. TRUE if integration is for point surveys.
FALSE for line-transect surveys. Line-transect surveys integrate 
under the distance function, g(x), while point surveys integrate under 
the distance function times distances, xg(x).}
}
\value{
A vector of areas under the distance functions represented in 
\code{object}. 
If \code{object} is a distance function and 
\code{newdata} is specified, the returned vector's length is 
\code{nrow(newdata)}.  If \code{object} is a distance function and 
\code{newdata} is NULL, 
returned vector's length is \code{length(distances(object))}. If 
\code{object} is a matrix, return's length is 
\code{nrow(object)}.
}
\description{
Compute integral of the one-step distance function
using numeric integration. This function is only called for 
oneStep functions that contain expansion factors.
}
\details{
The \code{\link{oneStep.like}} function has an extremely large 
discontinuity at Theta. Accurate numeric integration requires 
inserting Theta and Theta+ (a value just larger than Theta) 
into the series of points being evaluated. Because this creates 
un-equal intervals, the Trapazoid rule must be used. 
Rdistance's Simpson's rule routine 
(\code{\link{integrateNumeric}}) will not work for oneStep likelihoods 
that have expansions.
}
\section{Note}{

Users will not normally call this function. It is called 
internally by \code{\link{nLL}} and \code{\link{effectiveDistance}}.
}

\seealso{
\code{\link{integrateNumeric}}; 
\code{\link{integrateOneStepLines}}; \code{\link{integrateOneStepPoints}}
}
