% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predDensity.R
\name{predDensity}
\alias{predDensity}
\title{Density on transects}
\usage{
predDensity(object, propUnitSurveyed = 1)
}
\arguments{
\item{object}{An Rdistance model frame or fitted distance function,
normally produced by a call to \code{\link{dfuncEstim}}.}

\item{propUnitSurveyed}{A scalar or vector of real numbers between 0 and 1.
The proportion of the default sampling unit that 
  was surveyed.  If both sides of line transects were observed, 
  \code{propUnitSurveyed}
  = 1.  If only a single side of line transects were observed, set 
  \code{propUnitSurveyed} = 0.5. For point transects, this should be set to 
  the proportion of each circle that was observed. Length must either be
  1 or the total number of transects in \code{x}.}
}
\value{
A data frame containing the original data used 
to fit the distance function, plus an additional column
containing the density of individuals on each transect.
}
\description{
An internal prediction method for computing density 
on the sampled transects.
}
\examples{
data(sparrowDfuncObserver)
predict(sparrowDfuncObserver, type="density")

 
}
