% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppTskit.R
\name{tc_py_to_r}
\alias{tc_py_to_r}
\title{Transfer a table collection from reticulate Python to R}
\usage{
tc_py_to_r(tc, cleanup = TRUE)
}
\arguments{
\item{tc}{table collection in reticulate Python.}

\item{cleanup}{logical; delete the temporary file at the end of the function?}
}
\value{
A \code{\link{TableCollection}} object.
}
\description{
This function saves a table collection from reticulate Python
  to disk and reads it into R for use with \code{RcppTskit}.
}
\examples{
\dontrun{
  ts_file <- system.file("examples/test.trees", package = "RcppTskit")

  # Use the tskit Python API to work with a table collection (via reticulate)
  tskit <- get_tskit_py()
  if (check_tskit_py(tskit)) {
    tc_py <- tskit$TableCollection$load(ts_file)
    is(tc_py)
    tc_py$individuals$num_rows # 8
    tmp <- tc_py$simplify(samples = c(0L, 1L, 2L, 3L))
    tmp
    tc_py$individuals$num_rows # 2
    tc_py$nodes$num_rows # 8
    tc_py$nodes$time # 0.0 ... 5.0093910

    # Transfer the table collection to R and use RcppTskit
    tc_r <- tc_py_to_r(tc_py)
    is(tc_r)
   tc_r$print()
  }
}
}
\seealso{
\code{\link[=TableCollection]{TableCollection$r_to_py}}
  \code{\link{tc_load}}, and \code{\link[=TableCollection]{TableCollection$dump}}.
}
