% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbentfit.R
\name{rbentfit}
\alias{rbentfit}
\title{rank estimation for bent line regression}
\usage{
rbentfit(y, z, x, bet.ini, tau.ini, tol = 1e-04, max.iter = 50)
}
\arguments{
\item{y}{A vector of response}

\item{z}{A vector of covariates}

\item{x}{A numeric variable with change point}

\item{bet.ini}{A initial vector of regression coefficients}

\item{tau.ini}{A initial value of change point}

\item{tol}{tolerance value, 1e-4 for default}

\item{max.iter}{the maximum iteration steps}
}
\value{
A list with the elements
\item{est}{The estimated regression coefficients with intercept.}
\item{bp}{The estimated change point.}
\item{est.se}{The estimated standard error of the regression coefficients.}
\item{bp.est}{The estimated standard error of the change point.}
\item{iter}{The iteration steps.}
}
\description{
This function use Wilcoxon score functions for
fitting the bent line regression model.
}
\examples{
n <- 150
x <- runif(n, 0, 4)
z <- rnorm(n, 1, 1)
y <- 1 + 0.5*z + 1.5*x  - 3 *pmax(x-2, 0)  + rt(n, 2)
rbentfit(y, cbind(1,z), x, bet.ini = c(0, 1, 1, -2), tau.ini = 1)

# for the example of  MRS data
data(data_mrs)
x <- log(data_mrs$mass)
y <- log(data_mrs$speed)
z <- data_mrs$hopper
tau.ini <- 3
dat.new <- data.frame(y=y, z1=z, z2 = x, z3=pmax(x-tau.ini,0))
library(Rfit)
fit.ini <- rfit(y~ z1 + z2 +z3, data= dat.new)   # with intercept
bet.ini <- fit.ini$coef
fit.rank <- rbentfit(y, cbind(1,z), x, bet.ini, tau.ini)
}
\author{
Feipeng Zhang
}
\keyword{rbentfit}

