% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rationalMatrix.R
\name{QcholUtDU}
\alias{QcholUtDU}
\title{'UtDU' decomposition of a rational matrix}
\usage{
QcholUtDU(M)
}
\arguments{
\item{M}{a square matrix such that \code{as.character(Mij)} is 
a quoted integer or a quoted fraction for each entry \code{Mij}}
}
\value{
The Cholesky-'UtDU' decomposition of \code{M} in a list 
  (see example).
}
\description{
Cholesky-'UtDU' decomposition of a symmetric rational matrix.
}
\note{
Symmetry is not checked! Only the lower triangular part of 
  \code{M} is used.
}
\examples{
library(RationalMatrix)
x <- matrix(c(1:5, (1:5)^2), 5, 2)
x <- cbind(x, x[, 1L] + 3L*x[, 2L])
M <- crossprod(x)
UtDU <- QcholUtDU(M)
library(gmp)
U <- as.bigq(UtDU$U)
D <- matrix("0", 3L, 3L)
diag(D) <- UtDU$D
D <- as.bigq(D)
perm <- UtDU$perm
UP <- U[, perm]
t(UP) \%*\% D \%*\% UP # this is `M`
}
