% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prefix_similarity}
\alias{prefix_similarity}
\title{Calculate the prefix similarity between two strings}
\usage{
prefix_similarity(s1, s2, score_cutoff = 0L)
}
\arguments{
\item{s1}{A string. The first input string.}

\item{s2}{A string. The second input string.}

\item{score_cutoff}{An optional minimum threshold for the similarity score. Defaults to 0.}
}
\value{
The prefix similarity as an integer.
}
\description{
Computes the similarity of the prefixes of two strings based on their number of matching characters.
}
\examples{
prefix_similarity("abcdef", "abcxyz")
prefix_similarity("abcdef", "abcxyz", score_cutoff = 3)
}
