% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_functions.R
\name{evaluationMatrix}
\alias{evaluationMatrix}
\title{Evaluation matrix}
\usage{
evaluationMatrix(x)
}
\arguments{
\item{x}{a \code{data.frame} containing columns titled \code{Reviewer}, \code{Item},
\code{Ranking}. On data structure, \code{Reviewer} and \code{Item} must be
character, and \code{Ranking} must be numeric. Each row of \code{x}
identifes the rank position that a single \code{Reviewer} awarded a single
\code{Item}}
}
\value{
An \code{m x n} pairwise \code{matrix} giving the number of times
\code{Item[m]} is preferred to (i.e. receives a ranking value lower than)
\code{Item[n]} across all \code{Reviewer} \code{Rankings}
}
\description{
This function is called by \code{\link{RankAggregator}}::\code{\link{consensusRanking}}.
For each pair of \code{Item}s, whenever both \code{Item}s are ranked by the
same \code{Reviewer}, this function sums the occurances when each of the two
\code{Item}s is preferred to the other.
}
\examples{
evaluationMatrix(cook_example)
}
