% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.radviz.R
\name{do.radviz}
\alias{do.radviz}
\alias{do.radviz.default}
\title{Projects a Matrix or a Data Frame to a 2D space defined by Dimensional Anchors}
\usage{
do.radviz(
  x,
  springs,
  trans = do.L,
  scaling = 1,
  label.color = "orangered4",
  label.size = NA,
  type = NULL,
  graph = NULL
)
}
\arguments{
\item{x}{a data.frame or matrix to be projected, with column names matching row names in springs}

\item{springs}{a matrix of 2D dimensional anchor coordinates, as returned by \code{\link{make.S}}}

\item{trans}{a transformation to be applied to the data before projection}

\item{scaling}{a scaling factor applied to data before the projection.}

\item{label.color}{deprecated, use \code{\link{plot.radviz}} instead}

\item{label.size}{deprecated, use \code{\link{plot.radviz}} instead}

\item{type}{character string specifying the method used for obtaining the springs. 
Current methods are: Radviz, Freeviz and Graphviz. When not provided, \code{type} is 
derived from the other inputs}

\item{graph}{\code{igraph} object (only relevant for result obtained from \code{\link{do.optimGraphviz}} analysis)}
}
\value{
an object of class radviz with the following slots:
		\itemize{
				\item \code{proj}: a ggplot2 object with a single geom_text layer corresponding to springs.
           	the \code{data} slot of the ggplot2 corresponds to the input parameter \code{x}
           	with the following extra columns:
         		\itemize{
           			\item \code{rx} and \code{ry} the X and Y coordinates of the radviz projection of \code{x} over \code{springs}
           			\item \code{rvalid} an index of points corresponding to an invalid projection (any \code{rx} or \code{ry} is NA)
				}
				\item \code{springs}: the matrix containing the spring coordinates.
				\item \code{type}: character string specifying the method used for obtaining the springs.
				\item \code{trans}: the function used to transform the data.
       \item \code{graphEdges}: when the input \code{graph} is provided (for a Graphviz analysis),
             this slot will contain a dataframe with the graph edges
}
}
\description{
do.radviz will return a projection of a multidimensional dataset onto a 2D space
defined by dimensional anchors that have been projected on the unit circle using
\code{\link{make.S}}
}
\details{
The function expects that at least some of the column names in x 
will be matched by all row names in springs.
The scaling factor can be used to increase the distance between points, 
making it useful in situations where all points are pulled together either 
because of similar values or large number of channels.
The scaling is applied **after** the transformation by \code{trans}.
The scaling idea is taken from [Artur & Minghim 2019](https://doi.org/10.1016/j.cag.2019.08.015).
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
summary(rv)
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
iris0 <- rbind(iris,c(rep(0,length(das)),NA))
S <- make.S(das)
rv0 <- do.radviz(iris0,S)

sum(!is.valid(rv0)) # should be 1

# to find which points where invalid in the data
which(!is.valid(rv0))

# to review the original data points
rv1 <- subset(rv0,is.valid(rv0))

summary(rv1)
}
\author{
Yann Abraham
}
